-- SafeSleep.applescript
-- Created by adb on 28.11.05.
-- Copyright 2005 c't - Magazin fr Computertechnik

global gHasEncryptedSwap
global gHasSafeSleep
global gNvramrc
global gUseNvramrc

property kInstall : 1
property kRemove : 2
property kActivate : 3
property kDeactivate : 4
property kShutdown : 5


on should quit after last window closed theObject
	quit
end should quit after last window closed


on InstallPatch(clickedObject)
	set crChar to ASCII character 13
	set old to (do shell script ("/usr/sbin/nvram nvramrc"))
	set c to (number of characters of old)
	
	if c > 8 then
		if "has-safe-sleep" is not in old then
			set old to (characters 9 thru c of old) & crChar as string
		end if
	else
		set old to ""
	end if
	
	set cmd to "\" /\" select-dev" & crChar & "\" adb\" encode-string \" has-safe-sleep\" property" & crChar & "unselect-dev" & crChar
	set cmd to old & cmd
	set cmd to quoted form of cmd
	
	ChangeNVRAM(cmd, "true")
	UpdateGUI(window "SafeSleeperWindow")
	
	set click to button returned of (display dialog "Soll SaveSleeper den Rechner neu starten, damit die nderungen wirksam werden?" buttons {"Ja", "Nein"} default button 2)
	if click = "Ja" then
		tell application "System Events"
			restart
		end tell
	end if
end InstallPatch


on RemovePatch(clickedObject)
	do shell script ("/usr/bin/pmset -a hibernatemode 0") with administrator privileges
	ChangeNVRAM("", "false")
	UpdateGUI(window "SafeSleeperWindow")
	
	set click to button returned of (display dialog "Soll SaveSleeper den Rechner neu starten, damit die nderungen wirksam werden?" buttons {"Ja", "Nein"} default button 2)
	if click = "Ja" then
		tell application "System Events"
			restart
		end tell
	end if
end RemovePatch


on ActivateSaveSleep(clickedObject)
	if gHasEncryptedSwap then
		do shell script ("/usr/bin/pmset -a hibernatemode 7") with administrator privileges
	else
		do shell script ("/usr/bin/pmset -a hibernatemode 3") with administrator privileges
	end if
	
	UpdateGUI(window "SafeSleeperWindow")
end ActivateSaveSleep


on DeactivateSaveSleep(clickedObject)
	do shell script ("/usr/bin/pmset -a hibernatemode 0") with administrator privileges
	
	UpdateGUI(window "SafeSleeperWindow")
end DeactivateSaveSleep


on ActivateSaveSleepAndShutdown(clickedObject)
	if gHasEncryptedSwap then
		do shell script ("/usr/bin/pmset -a hibernatemode 5") with administrator privileges
	else
		do shell script ("/usr/bin/pmset -a hibernatemode 1") with administrator privileges
	end if
	
	UpdateGUI(window "SafeSleeperWindow")
end ActivateSaveSleepAndShutdown


on ChangeNVRAM(cmd, anaus)
	try
		do shell script ("/usr/sbin/nvram nvramrc=" & cmd) with administrator privileges
		do shell script ("/usr/sbin/nvram use-nvramrc\\?=" & anaus) with administrator privileges
		
	on error what
		error what
		quit
	end try
end ChangeNVRAM


on clicked theObject
	set clickedObject to (tag of theObject)
	if clickedObject is 1 then
		InstallPatch(theObject)
	else if clickedObject is 2 then
		RemovePatch(theObject)
	else if clickedObject is 3 then
		ActivateSaveSleep(theObject)
	else if clickedObject is 4 then
		DeactivateSaveSleep(theObject)
	else if clickedObject is 5 then
		ActivateSaveSleepAndShutdown(theObject)
	end if
end clicked


on UpdateGUI(mainWindow)
	tell mainWindow
		set vers to (((system attribute "sysv") as number) - 4096)
		set versStr to ""
		if vers > 0 then set versStr to "10."
		set versStr to versStr & ((vers div 16) as string)
		set versStr to versStr & "." & ((vers mod 16) as string)
		
		set infoPatch to "Systemversion: Mac OS X " & versStr & return & "AppleKauaiATA-Treiber geladen." & return & "Save-Sleep-Patch ist "
		
		set gHasSafeSleep to ((do shell script "/usr/sbin/ioreg -l -w 0") contains "\"has-safe-sleep\" = ")
		set gHasEncryptedSwap to ("ENCRYPTSWAP=-YES-" is in (do shell script "/bin/cat /etc/hostconfig"))
		set gUseNvramrc to ("true" is in (do shell script "/usr/sbin/nvram \"use-nvramrc?\""))
		set gNvramrc to (do shell script "/usr/sbin/nvram \"nvramrc\"")
		
		set sleepfile to (do shell script "/usr/bin/pmset -g | /usr/bin/awk '/hibernatefile/ {print $2}'")
		
		if sleepfile = "" then
			set infoSleepimage to "Datei 'Sleepimage' ist nicht angelegt." & return
		else
			set infoSleepimage to sleepfile & " ist vorhanden." & return & "Gre: "
			set infoSleepimage to infoSleepimage & (do shell script "/usr/bin/stat -f '%z' " & sleepfile) & " Bytes" & return
		end if
		
		if gHasSafeSleep then
			set infoPatch to infoPatch & "aktiv."
			set infoSleepimage to infoSleepimage & "Save Sleep kann aktiviert werden."
		else
			set infoPatch to infoPatch & "nicht installiert."
			set infoSleepimage to infoSleepimage & "Save Sleep kann nicht aktiviert werden."
		end if
		
		set sleepmode to (do shell script "/usr/bin/pmset -g | /usr/bin/awk '/hibernatemode/ {print $2}'") as number
		if sleepmode = "" then set sleepmode to 0
		
		set enabled of button "InstallPatch" to (not gHasSafeSleep)
		set enabled of button "RemovePatch" to gHasSafeSleep
		set enabled of button "ActivateSaveSleep" to (gHasSafeSleep and (sleepmode = 0))
		set enabled of button "DeactivateSafeSleep" to (gHasSafeSleep and (sleepmode > 0))
		set enabled of button "ActivateSaveSleepAndShutdown" to gHasSafeSleep
		
		set contents of text field "InfoOFPatch" to infoPatch
		set contents of text field "InfoSleepFile" to infoSleepimage
		
		set visible to true
	end tell
end UpdateGUI


on will finish launching theObject
	if (((system attribute "sysv") as number) < 4163) then
		display dialog "Der SafeSleeper arbeitet erst ab Mac OS X 10.4.3. Weitere Informationen entnehmen Sie dem Artikel 'Behteter Schlaf' in der c't 26/05 ab S. 230." buttons {"OK"} default button 1
		quit
	end if
	
	if "com.apple.driver.AppleKauaiATA" is not in (do shell script "/usr/sbin/kextstat") then
		display dialog "Der SafeSleeper scheint auf diesem Rechner nicht zu arbeiten (AppleKauaiATA.kext nicht geladen). " buttons {"OK"} default button 1
		quit
	end if
end will finish launching


on awake from nib theObject
	if theObject is window "SafeSleeperWindow" then
		UpdateGUI(theObject)
	end if
end awake from nib
